// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityShot.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntityShot.h"
#include "Level.h"
#include "Application.h"




EntityShot::EntityShot()
{

  m_DiesIfOutsideScreen = true;
  m_CanSleep = false;

}



EntityShot::~EntityShot() 
{
}



void EntityShot::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_BLOCKED_LEFT:
    case EE_BLOCKED_RIGHT:
    case EE_BLOCKED_TOP:
    case EE_BLOCKED_BOTTOM:
      Die();
      break;
    case EE_DIE:
      m_pLevel->SpawnEntity( Dobbs::ENTITY_TYPE_EXPLOSION, 0, GetX(), GetY() );
      g_App.PlaySound( "Laser.Explode" );
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



